/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.spi.ValidationResult;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.openide.util.Lookup;

public class Validation {
    private static Collection<Validator> ourValidators;
    private List<Model> myValidatedModels;
    private List<Validator.ResultItem> myValidationResult = new ArrayList<Validator.ResultItem>();
    private static boolean isStopped;

    public Validation() {
        this.myValidatedModels = new ArrayList<Model>();
    }

    public void validate(Model model, ValidationType type) {
        isStopped = false;
        if (this.myValidatedModels.contains(model)) {
            return;
        }
        this.myValidatedModels.add(model);
        for (Validator validator : ourValidators) {
            if (isStopped) {
                this.myValidationResult = null;
                this.myValidatedModels = new ArrayList<Model>();
                break;
            }
            ValidationResult result = validator.validate(model, this, type);
            if (result == null) continue;
            this.myValidationResult.addAll(result.getValidationResult());
            this.myValidatedModels.addAll(result.getValidatedModels());
        }
        LinkedList<Validator.ResultItem> errors = new LinkedList<Validator.ResultItem>();
        LinkedList<Validator.ResultItem> advices = new LinkedList<Validator.ResultItem>();
        LinkedList<Validator.ResultItem> warnings = new LinkedList<Validator.ResultItem>();
        if (this.myValidationResult == null) {
            this.myValidationResult = new ArrayList<Validator.ResultItem>();
            return;
        }
        for (Validator.ResultItem item : this.myValidationResult) {
            if (item.getType() == Validator.ResultType.ERROR) {
                errors.add(item);
                continue;
            }
            if (item.getType() == Validator.ResultType.ADVICE) {
                advices.add(item);
                continue;
            }
            if (item.getType() != Validator.ResultType.WARNING) continue;
            warnings.add(item);
        }
        this.myValidationResult = new LinkedList<Validator.ResultItem>();
        this.myValidationResult.addAll(warnings);
        this.myValidationResult.addAll(advices);
        this.myValidationResult.addAll(errors);
    }

    public List<Validator.ResultItem> getValidationResult() {
        if (this.myValidationResult == null) {
            return null;
        }
        return Collections.unmodifiableList(this.myValidationResult);
    }

    public List<Model> getValidatedModels() {
        return Collections.unmodifiableList(this.myValidatedModels);
    }

    private static void lookupProviders() {
        if (ourValidators != null) {
            return;
        }
        ourValidators = new ArrayList<Validator>();
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(Validator.class));
        for (Object object : result.allInstances()) {
            ourValidators.add((Validator)object);
        }
    }

    public static void stop() {
        isStopped = true;
    }

    static {
        Validation.lookupProviders();
        isStopped = false;
    }

    public static enum ValidationType {
        COMPLETE,
        PARTIAL;

    }
}

